#!/bin/bash

set -euo pipefail
shopt -s inherit_errexit

if [[ -f /var/lib/vultr/config/.application-installed ]]; then
	echo "Application script completion detected - not re-running"
	exit 0
fi

. /opt/oct-installer/common.sh

arch="${OCTENIUM_COMMON_ARCHITECTURE:-$(uname -m)}"
if [[ "${arch}" != arm64 ]]; then
	arch="amd64"
fi

########
echo "Retrieve necessary values from metadata"
########
get_var grafanapass

ip="$(curl -s https://files.oct-backend.com/octeniumvz/ip.php)"

########
echo "Disable unattended upgrades while configuring app"
########
toggle_unattended_upgrades "disable"

########
echo "Install Grafana"
########
curl -fsSL https://apt.grafana.com/gpg.key | gpg --dearmor -o /usr/share/keyrings/grafana.gpg

printf 'deb [arch=%s signed-by=%s] %s %s %s\ndeb [arch=%s signed-by=%s] %s %s %s\n' \
	"${arch}" \
	"/usr/share/keyrings/grafana.gpg" \
	"https://apt.grafana.com" \
	"stable" \
	"main" \
	"${arch}" \
	"/usr/share/keyrings/grafana.gpg" \
	"https://apt.grafana.com" \
	"beta" \
	"main" > /etc/apt/sources.list.d/grafana.list

install_packages grafana

sed -i \
	-e "s/^;http_addr = .*/http_addr = ${ip}/" \
	-e "s/^;*\s*admin_password\s*=.*/admin_password = ${grafanapass}/" /etc/grafana/grafana.ini

########
echo "Remove any remaining unnecessary packages"
########
autoremove_packages

########
echo "Re-enable unattended upgrades as app is configured"
########
toggle_unattended_upgrades "enable"
cleanup_imageless

########
echo "Enable services"
########
initsvc enablenow grafana-server

########
echo "Configure firewall"
########
ufw default deny incoming
ufw allow 3000/tcp
ufw status verbose
