#!/bin/bash

set -e

# 1) Update the server OS
echo ">>> Updating server..."
if [ -f /etc/debian_version ]; then
    apt update -y && apt upgrade -y
elif [ -f /etc/redhat-release ]; then
    yum update -y
else
    echo "Unsupported OS"
    exit 1
fi

# 2) Install wget if missing
echo ">>> Ensuring wget is installed..."
if ! command -v wget >/dev/null 2>&1; then
    if [ -f /etc/debian_version ]; then
        apt install wget -y
    else
        yum install wget -y
    fi
fi

# 3) Download the official installer

LOG=/opt/oct-installer/ins_ispmanager.log

echo ">>> Downloading ISPmanager installer..."
wget https://download.ispmanager.com/install.eu.sh -O /opt/oct-installer/install_isp.sh
chmod +x /opt/oct-installer/install_isp.sh

# 4) Run installer with silent defaults
echo ">>> Running ISPmanager installer (stable, recommended)..."
sh /opt/oct-installer/install_isp.sh --release stable ispmanager-lite --silent  >> $LOG 2>&1

# 5) (Optional) Let’s Encrypt disabled by default
#    Remove this line if you DO want auto‑LE cert
echo ">>> Disabling automatic Let’s Encrypt issuance..."
sed -i '/le-domain/d' /usr/local/mgr5/etc/ispmgr.conf || true

