#!/bin/bash
set -e

echo "=== ONLYOFFICE Docs Docker Installation Script ==="

# 1️⃣ Update system
echo "Updating package lists…"
apt update && apt upgrade -y

# 2️⃣ Install prerequisites
echo "Installing required system packages…"
apt install -y curl gnupg lsb-release

# 3️⃣ Install Docker (official script)
echo "Installing Docker…"
curl -fsSL https://get.docker.com | sh

# 4️⃣ Optional: Create dedicated directories for persistent data
echo "Creating data directories…"
mkdir -p /opt/onlyoffice/logs \
         /opt/onlyoffice/data \
         /opt/onlyoffice/lib \
         /opt/onlyoffice/db

# 5️⃣ Run ONLYOFFICE Docs container
# Replace 'my_jwt_secret_value' with your own secure string
JWT_SECRET="my_jwt_secret_value"
echo "Starting ONLYOFFICE Document Server container…"

docker run -d \
  --name onlyoffice-document-server \
  -p 80:80 -p 443:443 \
  --restart=always \
  -e JWT_SECRET="$JWT_SECRET" \
  -v /opt/onlyoffice/logs:/var/log/onlyoffice \
  -v /opt/onlyoffice/data:/var/www/onlyoffice/Data \
  -v /opt/onlyoffice/lib:/var/lib/onlyoffice \
  -v /opt/onlyoffice/db:/var/lib/postgresql \
  onlyoffice/documentserver:9.2.0.1

echo "ONLYOFFICE Docs installation complete!"
echo "✔ Access via http://<your‑server‑ip> or https://<your‑server‑ip>"
echo "✔ Container name: onlyoffice-document-server"
echo "✔ Docker image: onlyoffice/documentserver:9.2.0.1"