#!/bin/bash
set -e

. /opt/oct-installer/common.sh

echo "=== ONLYOFFICE Workspace Community Installation ==="

########
echo "Retrieve necessary variables from metadata"
########
get_ip

# Exit if any required variables are not set
: "${ip:?}"


#  Update system
echo "Updating package lists…"
apt update && apt upgrade -y

# Install prerequisites
echo "Installing required system packages (curl, unzip, etc)…"
apt install -y curl gnupg lsb-release ca-certificates

#  Install Docker (official script)
echo "Installing Docker…"
curl -fsSL https://get.docker.com | sh

#  Ensure Docker is running
echo "Enabling and starting Docker…"
systemctl enable docker
systemctl start docker

# Download ONLYOFFICE Workspace Community install script
echo "Downloading ONLYOFFICE Workspace install script…"
curl -LO https://download.onlyoffice.com/install/workspace-install.sh
chmod +x workspace-install.sh

#  Run ONLYOFFICE Workspace installation
# If you do not want mail installed, you can pass -ims false
echo "Running ONLYOFFICE Workspace install script…"
#bash workspace-install.sh -md "$ip"

echo Y | sudo bash workspace-install.sh \
  --installationtype WORKSPACE \
  --installcs true \
  --installdocs true \
  --installcontrolpanel true \
  --installmailserver false \
  --useasexternalserver true \
  --documentserverip "$ip"
  
echo "ONLYOFFICE Workspace installation completed!"
