#!/bin/bash

if [[ -f /var/lib/oct/config/.plesk-installed ]]; then
	echo "Application script completion detected - not re-running"
	exit 0
fi

LOG=/opt/oct-installer/ins_plesk.log

cd /root

PKG_INSTALLER="yum"

if [ -e /etc/debian_version ]; then
  PKG_INSTALLER="apt-get"
  export DEBIAN_FRONTEND=noninteractive
  apt-get -y update
fi

# Installing wget
$PKG_INSTALLER -y install wget >> $LOG 2>&1

# Install Plesk

sh <(curl https://autoinstall.plesk.com/one-click-installer || wget -O - https://autoinstall.plesk.com/one-click-installer) >> /opt/oct-installer/ins_plesk.log 2>&1 

