#!/bin/bash

set -euo pipefail
shopt -s inherit_errexit

if [[ -f /var/lib/vultr/config/.application-installed ]]; then
	echo "Application script completion detected - not re-running"
	exit 0
fi

. /opt/oct-installer/common.sh

########
echo "Disable unattended upgrades while configuring app"
########
toggle_unattended_upgrades "disable"

########
echo "Install Node.JS"
########
curl --fail --silent --show-error --location https://deb.nodesource.com/setup_22.x | bash -
install_packages nodejs

########
echo "Create user"
########
useradd --skel /etc/skel --create-home --home-dir /home/strapi --shell /usr/sbin/nologin strapi

########
echo "Install Strapi"
########
runuser -l strapi -s /bin/bash -c "
	set -euo pipefail
	shopt -s inherit_errexit
	npx create-strapi@latest my-project --typescript --install --git-init --no-example --skip-cloud --skip-db --no-run <<< 'N'
"
mv /opt/oct-installer/strapi.service /usr/lib/systemd/system/
########
echo "Re-enable unattended upgrades as app is configured"
########
toggle_unattended_upgrades "enable"
cleanup_imageless

########
echo "Enable services"
########
initsvc enablenow strapi