#!/bin/bash

set -euo pipefail
shopt -s inherit_errexit

CONFIG_FILE="/var/www/html/wp-config.php"
if [[ ! -f "${CONFIG_FILE}" ]]; then
	echo "ERROR: ${CONFIG_FILE} is missing."
	exit 1
fi

# Create password
PASS="$(
	set +eo pipefail
	tr --delete --complement "[:alpha:]" < /dev/urandom | head --bytes=15
)"

# Get DB prefix
PREFIX="$(awk -F"'" '/table_prefix/ {print $2}' "${CONFIG_FILE}")"
if [[ -z "${PREFIX}" ]]; then
	echo "There is no 'table_prefix' defined in ${CONFIG_FILE}, did you go through the install process?"
	exit 1
fi

# Get DB
DB="$(awk -F"'" '/DB_NAME/ {print $4}' "${CONFIG_FILE}")"
if [[ -z "${DB}" ]]; then
	echo "There is no 'DB_NAME' defined in ${CONFIG_FILE}, did you go through the install process?"
	exit 1
fi

# Get User at 1
USER="$(
	mysql --defaults-file=/root/.my.cnf -B --disable-column-names -u root \
		-e "USE ${DB}; SELECT user_login FROM ${PREFIX}users WHERE ID='1';"
)"
if [[ -z "${USER}" ]]; then
	echo 'The file database is either missing the root user, did you go through the install process?'
	exit 1
fi

# Set password
mysql --defaults-file=/root/.my.cnf -u root \
	-e "USE ${DB}; UPDATE ${PREFIX}users SET user_pass=MD5('${PASS}') WHERE ID=1;"

# Give result
echo "The new password for the account '${USER}' is: ${PASS}"